/*
 Copyright (c) 2006-2009 [Joerg Ruedenauer]
 
 This file is part of RPGameValues.

 RPGameValues is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 RPGameValues is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with RPGameValues; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package rpgamevalues.control;

import rpgamevalues.data.Hero;
import rpgamevalues.metadata.DiceSpecification;
import rpgamevalues.metadata.GameValues;
import rpgamevalues.metadata.IGameValue;

final class HeroFactory {

  public static Hero createNewHero(String name) {
    Hero hero = new Hero(name);
    for (String valueGroup : GameValues.getInstance().getGroups()) {
      for (IGameValue value : GameValues.getInstance().getGameValues(valueGroup)) {
        switch (value.getGameValueType()) {
        case DiceSpecification:
          {
            DiceSpecification startValue = (DiceSpecification)value.getStartValue();
            setStartValue(hero, valueGroup, value.getName(), value, startValue);
            break;
          }
        case Boolean:
          {
            Boolean startValue = (Boolean)value.getStartValue();
            setStartValue(hero, valueGroup, value.getName(), value, startValue);
            break;
          }
        case String:
          {
        	String startValue = (String)value.getStartValue();
        	setStartValue(hero, valueGroup, value.getName(), value, startValue); 
        	break;
          }
        default:
          {
            Integer startValue = (Integer)value.getStartValue();
            setStartValue(hero, valueGroup, value.getName(), value, startValue);
            break;
          }
        }
      }
    }
    return hero;
  }
  
  private static <T> void setStartValue(Hero hero, String group, String name, IGameValue gameValue, T value) {
    hero.setCurrentValue(group, name, value);
    if (!gameValue.isCalculated() && gameValue.hasDefault()) {
      hero.setDefaultValue(group, name, value);
    }
  }

}
