/*
 Copyright (c) 2006-2009 [Joerg Ruedenauer]
 
 This file is part of RPGameValues.

 RPGameValues is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 RPGameValues is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with RPGameValues; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */package rpgamevalues.control;

import java.io.IOException;
import java.util.prefs.Preferences;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import rpgamevalues.gui.MainFrame;
import rpgamevalues.gui.SubFrame;
import rpgamevalues.gui.lf.LookAndFeels;
import rpgamevalues.metadata.GameValues;
import rpgamevalues.util.Directories;


/**
 * 
 */
public class Main {
  
  private Main() {}

  private static java.util.List<String> startFiles = null;
  
  public static void main(String[] args) {
	String metaDataPath = (args.length > 0) ? args[0] : (Directories.getApplicationPath() + "GameValues.xml"); //$NON-NLS-1$
    try {
      GameValues.getInstance().readFile(metaDataPath);
    }
    catch (IOException e) {
      JOptionPane.showMessageDialog(null, Messages.getString("Main.CantReadMetaData") + e.getLocalizedMessage(), "RPGameValues", JOptionPane.ERROR_MESSAGE); //$NON-NLS-1$ //$NON-NLS-2$
      return;
    }
    SubFrame.setSaveLocations(false);
    String lastFile = Preferences.userNodeForPackage(SubFrame.class).get("LastGroup_" + GameValues.getInstance().getName(), ""); //$NON-NLS-1$ //$NON-NLS-2$
    if (lastFile != null && lastFile.length() != 0) {
      startFiles = new java.util.ArrayList<String>();
      startFiles.add(lastFile);
    }

    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        createAndShowGUI();
      }
    });
  }
  
  public static void exit(int retCode)
  {
    System.exit(retCode);
  }

  private static void createAndShowGUI() {
    try {
      LookAndFeels.setLastLookAndFeel();
      
      MainFrame mainFrame = new MainFrame();
      mainFrame.setVisible(true);
      if (startFiles != null) {
        mainFrame.openFile(startFiles.get(0));
      }
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}
