/*
 Copyright (c) 2006-2009 [Joerg Ruedenauer]
 
 This file is part of RPGameValues.

 RPGameValues is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 RPGameValues is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with RPGameValues; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package rpgamevalues.control;

import rpgamevalues.data.Hero;
import rpgamevalues.metadata.GameValues;
import rpgamevalues.metadata.IGameValue;
import rpgamevalues.metadata.ProbeType;

public final class Modificators {

  private Modificators() {}
  
  public static int getProbeModificator(Hero hero, ProbeType probeType) {
    int result = 0;
    for (String group : GameValues.getInstance().getGroups()) {
      for (IGameValue gameValue : GameValues.getInstance().getGameValues(group)) {
        if (gameValue.getGameValueType() == IGameValue.GameValueType.Number) {
          if (gameValue.hasDefault()) {
            result += gameValue.getProbeModificator(ValueCalculation.<Integer>getCurrentValue(group, gameValue, hero), 
                ValueCalculation.<Integer>getDefaultValue(group, gameValue, hero), probeType);
          }
          else {
            result += gameValue.getProbeModificator(ValueCalculation.<Integer>getCurrentValue(group, gameValue, hero), probeType);
          }
        }
      }
    }
    return result;
  }
  
  private static int getValueModificator(Hero hero, String groupName, String valueName) {
    int result = 0;
    for (String group : GameValues.getInstance().getGroups()) {
      for (IGameValue gameValue : GameValues.getInstance().getGameValues(group)) {
        if (gameValue.getGameValueType() == IGameValue.GameValueType.Number) {
          if (gameValue.hasDefault()) {
            result += gameValue.getValueModificator(ValueCalculation.<Integer>getCurrentValue(group, gameValue, hero), 
                ValueCalculation.<Integer>getDefaultValue(group, gameValue, hero), groupName, valueName);
          }
          else {
            result += gameValue.getValueModificator(ValueCalculation.<Integer>getCurrentValue(group, gameValue, hero), groupName, valueName);
          }
        }
      }
    }
    return result;
  }
  
  public static int getModifiedValue(Hero hero, String group, IGameValue gameValue) {
    if (gameValue.hasDefault() && ValueCalculation.<Integer>getDefaultValue(group, gameValue, hero) == 0) {
      return ValueCalculation.<Integer>getCurrentValue(group, gameValue, hero);
    }
    else {
      return ValueCalculation.<Integer>getCurrentValue(group, gameValue, hero) + getValueModificator(hero, group, gameValue.getName());
    }
  }
}
