/*
 Copyright (c) 2006-2009 [Joerg Ruedenauer]
 
 This file is part of RPGameValues.

 RPGameValues is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 RPGameValues is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with RPGameValues; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package rpgamevalues.control;

import rpgamevalues.metadata.DiceSpecification;
import rpgamevalues.metadata.Hero;
import rpgamevalues.metadata.IGameValue;

public final class ValueCalculation {

  private ValueCalculation() {}
  
  @SuppressWarnings("unchecked")
  private static <T> T getStartValueOrCurrentValue(IGameValue gameValue, T currentValue) {
    if (currentValue != null) {
      return currentValue;
    }
    else if (gameValue.getStartValue() != null) {
      return (T)gameValue.getStartValue();
    }
    else if (gameValue.getGameValueType() == IGameValue.GameValueType.Number) {
      return (T)(Integer)0;
    }
    else if (gameValue.getGameValueType() == IGameValue.GameValueType.Boolean) {
      return (T)(Boolean)false;
    }
    else if (gameValue.getGameValueType() == IGameValue.GameValueType.String) {
      return (T)"";
    }
    else {
      return (T)DiceSpecification.create(1, 6, 0);
    }
  }
  
  @SuppressWarnings("unchecked")
  public static <T> T getCurrentValue(String group, IGameValue gameValue, Hero hero) {
    if (gameValue.isCalculated()) {
      return (T)(Integer)gameValue.calcCurrentValue(hero);
    }
    else {
      return getStartValueOrCurrentValue(gameValue, hero.<T>getCurrentValue(group, gameValue.getName()));
    }
  }

  @SuppressWarnings("unchecked")
  public static <T> T getDefaultValue(String group, IGameValue gameValue, Hero hero) {
    if (gameValue.isCalculated()) {
      return (T)(Integer)gameValue.calcDefaultValue(hero);
    }
    else {
      return getStartValueOrCurrentValue(gameValue, hero.<T>getDefaultValue(group, gameValue.getName()));
    }
  }
}
