/*
 Copyright (c) 2006-2009 [Joerg Ruedenauer]
 
 This file is part of RPGameValues.

 RPGameValues is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 RPGameValues is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with RPGameValues; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package rpgamevalues.data;

final class GameValue<T> implements rpgamevalues.metadata.Cloneable {

  private T defaultValue;
  private T currentValue;
  
  public T getDefaultValue() {
    return defaultValue;
  }
  
  public T getCurrentValue() {
    return currentValue;
  }
  
  public void setDefaultValue(T value) {
    defaultValue = value;
  }
  
  public void setCurrentValue(T value) {
    currentValue = value;
  }
  
  @SuppressWarnings("unchecked")
  public GameValue clone() throws CloneNotSupportedException {
    GameValue<T> result = (GameValue<T>) super.clone();
    if (currentValue instanceof rpgamevalues.metadata.Cloneable) {
      result.setCurrentValue((T)((rpgamevalues.metadata.Cloneable)currentValue).clone());
      if (defaultValue != null) {
        result.setDefaultValue((T)((rpgamevalues.metadata.Cloneable)defaultValue).clone());
      }
    }
    return result;
  }
}
