/*
 Copyright (c) 2006-2009 [Joerg Ruedenauer]
 
 This file is part of RPGameValues.

 RPGameValues is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 RPGameValues is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with RPGameValues; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package rpgamevalues.data;

import java.util.HashMap;

public final class Group {

  private HashMap<String, Hero> heroes = new HashMap<String, Hero>();
  
  private boolean changed = false;
  
  private String filePath = ""; //$NON-NLS-1$
  
  private static Group sInstance = null;
  
  public static Group getGroup() {
    if (sInstance == null) {
      sInstance = new Group();
    }
    return sInstance;
  }
  
  public static void setGroup(Group group) {
    sInstance = group;
  }
  
  public String[] getHeroes() {
    String[] result = new String[heroes.size()];
    heroes.keySet().toArray(result);
    return result;
  }
  
  public void addHero(Hero hero) {
    if (!heroes.containsKey(hero.getName())) {
      heroes.put(hero.getName(), hero);
      changed = true;
    }
  }
  
  public void removeHero(String name) {
    if (heroes.containsKey(name)) {
      heroes.remove(name);
      changed = true;
    }
  }
  
  public Hero getHero(String name) {
    if (heroes.containsKey(name)) {
      return heroes.get(name);
    }
    return null;
  }
  
  public boolean isChanged() {
    for (Hero hero : heroes.values()) {
      if (hero.isChanged()) return true;
    }
    return changed;
  }
  
  public void setUnchanged() {
    for (Hero hero : heroes.values()) {
      hero.setUnchanged();
    }
    changed = false;
  }
  
  public void setFilePath(String path) {
    filePath = path;
  }
  
  public String getFilePath() {
    return filePath;
  }
}
