/*
 Copyright (c) 2006-2009 [Joerg Ruedenauer]
 
 This file is part of RPGameValues.

 RPGameValues is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 RPGameValues is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with RPGameValues; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package rpgamevalues.data;

import java.util.HashMap;

public final class Hero implements rpgamevalues.metadata.Hero {

  private String mName;
  
  private HashMap<String, Configurations> groupConfigurations = new HashMap<String, Configurations>();
  
  private int currentGroup;
  
  private boolean changed;
  
  public Hero(String name) {
    mName = name;
    changed = false;
    currentGroup = 0;
  }
  
  public String getName() {
    return mName;
  }
  
  public void setName(String name) {
    if (!mName.equals(name)) {
      mName = name;
      changed = true;
    }
  }
  
  public int getCurrentGroup() {
    return currentGroup;
  }
  
  public void setCurrentGroup(int group) {
    if (currentGroup != group) {
      currentGroup = group;
      changed = true;
    }
  }
  
  public String[] getConfigurations(String group) {
    if (!groupConfigurations.containsKey(group)) {
      groupConfigurations.put(group, new Configurations());
    }
    return groupConfigurations.get(group).getConfigurations();
  }
  
  public void addConfiguration(String group, String name) {
    if (!groupConfigurations.containsKey(group)) {
      groupConfigurations.put(group, new Configurations());
    }
    groupConfigurations.get(group).addConfiguration(name);
  }
  
  public void removeConfiguration(String group, String name) {
    if (!groupConfigurations.containsKey(group)) {
      groupConfigurations.put(group, new Configurations());
    }
    groupConfigurations.get(group).removeConfiguration(name);
  }
  
  public void duplicateConfiguration(String group, String newName) {
    if (!groupConfigurations.containsKey(group)) {
      groupConfigurations.put(group, new Configurations());
    }
    groupConfigurations.get(group).duplicateConfiguration(newName);
  }
  
  public String getCurrentConfiguration(String group) {
    if (!groupConfigurations.containsKey(group)) {
      groupConfigurations.put(group, new Configurations());
    }
    return groupConfigurations.get(group).getCurrentConfiguration();
  }
  
  public void setCurrentConfiguration(String group, String name) {
    if (!groupConfigurations.containsKey(group)) {
      groupConfigurations.put(group, new Configurations());
    }
    groupConfigurations.get(group).setCurrentConfiguration(name);
  }
  
  public void changeCurrentConfigurationName(String group, String name) {
    if (!groupConfigurations.containsKey(group)) {
      groupConfigurations.put(group, new Configurations());
    }
    groupConfigurations.get(group).changeCurrentConfigurationName(name);
  }
  
  public <T> T getCurrentValue(String group, String name) {
    if (!groupConfigurations.containsKey(group)) {
      groupConfigurations.put(group, new Configurations());
    }
    return groupConfigurations.get(group).<T>getCurrentValue(name);
  }
  
  public <T> T getDefaultValue(String group, String name) {
    if (!groupConfigurations.containsKey(group)) {
      groupConfigurations.put(group, new Configurations());
    }
    return groupConfigurations.get(group).<T>getDefaultValue(name);
  }
  
  public <T> void setCurrentValue(String group, String name, T value) {
    if (!groupConfigurations.containsKey(group)) {
      groupConfigurations.put(group, new Configurations());
    }
    groupConfigurations.get(group).setCurrentValue(name, value);
  }
  
  public <T> void setDefaultValue(String group, String name, T value) {
    if (!groupConfigurations.containsKey(group)) {
      groupConfigurations.put(group, new Configurations());
    }
    groupConfigurations.get(group).setDefaultValue(name, value);
  }
  
  public boolean isValueShown(String group, String name, boolean defaultValue) {
    if (!groupConfigurations.containsKey(group)) {
      groupConfigurations.put(group, new Configurations());
    }
    return groupConfigurations.get(group).isValueShown(name, defaultValue);
  }
  
  public void setValueShown(String group, String name, boolean shown) {
    if (!groupConfigurations.containsKey(group)) {
      groupConfigurations.put(group, new Configurations());
    }
    groupConfigurations.get(group).setValueShown(name, shown);
  }
  
  public boolean isChanged() {
    for (Configurations entry : groupConfigurations.values()) {
      if (entry.isChanged()) 
        return true;
    }
    return changed;
  }
  
  public void setUnchanged() {
    for (Configurations entry : groupConfigurations.values()) {
      entry.setUnchanged();
    }
    changed = false;
  }
}
