/*
 Copyright (c) 2006-2009 [Joerg Ruedenauer]
 
 This file is part of RPGameValues.

 RPGameValues is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 RPGameValues is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with RPGameValues; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package rpgamevalues.gui;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import rpgamevalues.data.Hero;
import rpgamevalues.metadata.GameValues;


class HeroFrame extends SubFrame implements IHeroFrame {
  
  private Hero hero;
  
  private JPanel jContentPane;
  private JTabbedPane tabPane;
  private JPanel labelsPane;
  
  public HeroFrame(Hero hero) {
    super(hero.getName());
    this.hero = hero;
    initialize();
  }
  
  private void initialize() {
    this.setContentPane(getJContentPane());
    this.setTitle(hero.getName());
    Preferences prefs = Preferences.userNodeForPackage(SubFrame.class);
    int x = prefs.getInt(hero.getName() + "w", -1); //$NON-NLS-1$
    if (x == -1)
    {
      this.pack();
    }
  }
  
  private JPanel getJContentPane() {
    if (jContentPane == null) {
      jContentPane = new JPanel();
      jContentPane.setLayout(new BorderLayout());
      jContentPane.add(getLabelsPane(), BorderLayout.NORTH);
      jContentPane.add(getTabPane(), BorderLayout.CENTER);
    }
    return jContentPane;
  }
  
  private JPanel getLabelsPane() {
    if (labelsPane == null) {
      labelsPane = new ProbeModsPanel(this, hero);
    }
    return labelsPane;
  }
  
  private JTabbedPane getTabPane() {
    if (tabPane == null) {
      tabPane = new JTabbedPane(JTabbedPane.BOTTOM, JTabbedPane.WRAP_TAB_LAYOUT);
      for (String groupName : GameValues.getInstance().getGroups()) {
        JPanel groupPanel = createGroupPanel(groupName);
        tabPane.add(groupName, groupPanel);
      }
      tabPane.setSelectedIndex(hero.getCurrentGroup());
      tabPane.addChangeListener(new ChangeListener() {
        public void stateChanged(ChangeEvent arg0) {
          hero.setCurrentGroup(tabPane.getSelectedIndex());
        }
      });
    }
    return tabPane;
  }
  
  private JPanel createGroupPanel(String groupName) {
    JPanel groupPanel = GameValues.getInstance().hasConfigurations(groupName) ? 
        new ConfigurationsPanel(this, hero, groupName) :
        new ValueGroupPanel(this, hero, groupName);
    return groupPanel;
  }

  /* (non-Javadoc)
   * @see rpgamevalues.gui.SubFrame#getHierarchyPosition()
   */
  @Override
  int getHierarchyPosition() {
    return 1;
  }
  
  private List<HeroChangerPanel> panels = new ArrayList<HeroChangerPanel>();

  /* (non-Javadoc)
   * @see rpgamevalues.gui.IHeroFrame#heroChanged()
   */
  @Override
  public void heroChanged() {
    for (HeroChangerPanel panel : panels) {
      panel.heroChanged();
    }
  }
  
  /* (non-Javadoc)
   * @see rpgamevalues.gui.IHeroFrame#registerPanel(rpgamevalues.gui.HeroChangerPanel)
   */
  @Override
  public void registerPanel(HeroChangerPanel panel) {
    panels.add(panel);
  }

}
