/*
 Copyright (c) 2006-2009 [Joerg Ruedenauer]
 
 This file is part of RPGameValues.

 RPGameValues is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 RPGameValues is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with RPGameValues; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package rpgamevalues.gui;

import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;

import rpgamevalues.control.Modificators;
import rpgamevalues.data.Hero;
import rpgamevalues.metadata.ProbeType;


class ProbeModsPanel extends HeroChangerPanel {
  
  private Hero hero;
  
  private JLabel[] valueLabels = new JLabel[ProbeType.values().length];
  private JLabel[] nameLabels = new JLabel[ProbeType.values().length];
  
  public ProbeModsPanel(IHeroFrame frame, Hero hero) {
    super(frame);
    this.hero = hero;
    initialize();
  }
  
  private void initialize() {
    setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(
        BorderFactory.createEtchedBorder(), Messages.getString("ProbeModsPanel.CheckDifficulties")), BorderFactory.createEmptyBorder(0, 0, 0, 0))); //$NON-NLS-1$
    GroupLayout layout = new GroupLayout(this);
    layout.setAutoCreateContainerGaps(true);
    layout.setAutoCreateGaps(false);
    
    for (int i = 0; i < valueLabels.length; ++i) {
      valueLabels[i] = new JLabel();
      nameLabels[i] = new JLabel(ProbeType.values()[i].toString() + ": "); //$NON-NLS-1$
    }

    layout.setHorizontalGroup(layout.createSequentialGroup()
        .addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addComponent(nameLabels[ProbeType.TALENT.ordinal()])
            .addComponent(nameLabels[ProbeType.PROPERTY.ordinal()])
            )
        .addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addComponent(valueLabels[ProbeType.TALENT.ordinal()])
            .addComponent(valueLabels[ProbeType.PROPERTY.ordinal()])
            )
        .addGap(20)        
        .addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addComponent(nameLabels[ProbeType.SPELL.ordinal()])
            .addComponent(nameLabels[ProbeType.FIGHT.ordinal()])
            )
        .addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addComponent(valueLabels[ProbeType.SPELL.ordinal()])
            .addComponent(valueLabels[ProbeType.FIGHT.ordinal()])
            )
        );
    
    layout.setVerticalGroup(layout.createSequentialGroup()
        .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
            .addComponent(nameLabels[ProbeType.TALENT.ordinal()])
            .addComponent(valueLabels[ProbeType.TALENT.ordinal()])
            .addComponent(nameLabels[ProbeType.SPELL.ordinal()])
            .addComponent(valueLabels[ProbeType.SPELL.ordinal()])
            )
        .addGap(5)
        .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
            .addComponent(nameLabels[ProbeType.PROPERTY.ordinal()])
            .addComponent(valueLabels[ProbeType.PROPERTY.ordinal()])
            .addComponent(nameLabels[ProbeType.FIGHT.ordinal()])
            .addComponent(valueLabels[ProbeType.FIGHT.ordinal()])
            )
        );
    
    setLayout(layout);
    
    heroChanged();
  }

  /* (non-Javadoc)
   * @see rpgamevalues.gui.HeroChangerPanel#heroChanged()
   */
  @Override
  public void heroChanged() {
    for (ProbeType pt : ProbeType.values()) {
      valueLabels[pt.ordinal()].setText("+" + Modificators.getProbeModificator(hero, pt)); //$NON-NLS-1$
    }
  }

}
