/*
 Copyright (c) 2006-2009 [Joerg Ruedenauer]
 
 This file is part of RPGameValues.

 RPGameValues is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 RPGameValues is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with RPGameValues; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package rpgamevalues.metadata;

public abstract class AbstractGameValue implements IGameValue {

  public abstract String getName();
  
  public boolean hasMax() { return false; }
  public boolean hasMin() { return false; }
  public boolean hasDefault() { return false; }
  
  public int getMax() { return 0; }
  public int getMin() { return 0; }
  
  public Object getStartValue() {
    if (hasMin()) return getMin();
    if (hasMax()) return getMax();
    return 0;
  }
  
  public int getProbeModificator(int currentValue, int defaultValue, ProbeType probeType)  { return 0; }
  public int getProbeModificator(int currentValue, ProbeType probeType)  { return 0; }
  public int getValueModificator(int currentValue, int defaultValue, String groupName, String valueName) { return 0; }
  public int getValueModificator(int currentValue, String groupName, String valueName) { return 0; }
  
  public GameValueType getGameValueType() { return GameValueType.Number; }
  
  public boolean isCalculated() { return false; }
  public int calcCurrentValue(Hero hero) { return 0; }
  public int calcDefaultValue(Hero hero) { return 0; }
  
  public boolean isVisibleByDefault() { return true; }
}
