/*
 Copyright (c) 2006-2009 [Joerg Ruedenauer]
 
 This file is part of RPGameValues.

 RPGameValues is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 RPGameValues is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with RPGameValues; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package rpgamevalues.metadata;

public final class DiceGameValue extends AbstractGameValue {
  
  private boolean hasDefault;
  private boolean hasStartValue;
  private String name;
  
  private DiceSpecification startValue;

  public DiceGameValue() {
    hasDefault = false;
    hasStartValue = false;
  }
  
  @Override
  public String getName() {
    return name;
  }

  public boolean hasDefault() {
    return hasDefault;
  }
  
  public GameValueType getGameValueType() {
    return GameValueType.DiceSpecification;
  }

  public void setProperty(String name, String value) {
    if (name.equalsIgnoreCase("name")) { //$NON-NLS-1$
      this.name = value;
    }
    else if (name.equalsIgnoreCase("hasDefault")) { //$NON-NLS-1$
      hasDefault = Boolean.parseBoolean(value);
    }
    else if (name.equalsIgnoreCase("startValue")) { //$NON-NLS-1$
      startValue = DiceSpecification.parse(value);
      hasStartValue = true;
    }
  }
  
  public Object getStartValue() {
    if (hasStartValue) {
      return startValue;
    }
    else {
      return null;
    }
  }
}
