/*
 Copyright (c) 2006-2009 [Joerg Ruedenauer]
 
 This file is part of RPGameValues.

 RPGameValues is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 RPGameValues is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with RPGameValues; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package rpgamevalues.metadata.dsa;

import java.util.List;

import rpgamevalues.control.ValueCalculation;
import rpgamevalues.metadata.GameValues;
import rpgamevalues.metadata.Hero;
import rpgamevalues.metadata.IGameValue;
import rpgamevalues.metadata.logic.PropertyBasedValue;

public final class AEBase extends PropertyBasedValue {

  private IGameValue sf;
  private String group;
  
  public AEBase() {
    setName("AE-Basis"); //$NON-NLS-1$
    setVisible(false);
    addProperty("Eigenschaften/MU"); //$NON-NLS-1$
    addProperty("Eigenschaften/IN"); //$NON-NLS-1$
    addProperty("Eigenschaften/CH"); //$NON-NLS-1$
    setDivisor(2);
    addAffectedValue("Energien/AE"); //$NON-NLS-1$
  }
  
  protected void getProperties(Hero hero, List<String> groups, List<String> names) {
    super.getProperties(hero, groups, names);
    if (sf == null) {
      findSF();
    }
    if (sf != null && ValueCalculation.<Boolean>getCurrentValue(group, sf, hero)) {
      groups.add("Eigenschaften");  //$NON-NLS-1$
      names.add("CH");  //$NON-NLS-1$
    }
  }
  
  private void findSF() {
    for (String aGroup : GameValues.getInstance().getGroups()) {
      for (IGameValue gameValue : GameValues.getInstance().getGameValues(aGroup)) {
          if (gameValue.getName().equalsIgnoreCase("gefäß der sterne")) { //$NON-NLS-1$
            group = aGroup;
            sf = gameValue;
            return;
          }
      }
    }
  }
}
