/*
 Copyright (c) 2006-2009 [Joerg Ruedenauer]
 
 This file is part of RPGameValues.

 RPGameValues is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 RPGameValues is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with RPGameValues; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package rpgamevalues.metadata.dsa;

import rpgamevalues.metadata.AbstractGameValue;
import rpgamevalues.metadata.ProbeType;

public final class Stamina extends AbstractGameValue {

  public String getName() {
    return "AU"; //$NON-NLS-1$
  }
  
  public boolean hasMin() { return true; }
  public boolean hasDefault() { return true; }
  
  public int getMin() { return 0; }

  public Object getStartValue() {
    return 25;
  }
  
  public int getProbeModificator(int currentValue, int defaultValue, ProbeType probeType)  {
    int fourth = defaultValue / 4;
    int third = defaultValue / 3;
    
    switch (probeType) {
    case PROPERTY:
    case FIGHT:
      if (currentValue < fourth) return 2;
      if (currentValue < third) return 1;
      return 0;
    case TALENT:
    case SPELL:
      if (currentValue < fourth) return 6;
      if (currentValue < third) return 3;
      return 0;
    }
    
    return 0;
  }
  
}
