/*
 Copyright (c) 2006-2009 [Joerg Ruedenauer]
 
 This file is part of RPGameValues.

 RPGameValues is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 RPGameValues is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with RPGameValues; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package rpgamevalues.metadata.dsa;

import rpgamevalues.metadata.AbstractGameValue;
import rpgamevalues.metadata.ProbeType;

public final class Wounds extends AbstractGameValue {

  public String getName() {
    return "Wunden"; //$NON-NLS-1$
  }
  
  public boolean hasMin() { return true; }
  
  public int getMin() { return 0; }
  
  public int getProbeModificator(int currentValue, ProbeType probeType)  {
    switch (probeType) {
    case SPELL:
      return 2 * currentValue;
    default:
      return 0;
    }
  }

  public int getValueModificator(int currentValue, String groupName, String valueName) { 
	if ("Eigenschaften".equals(groupName)) { //$NON-NLS-1$
	  if ("GE".equals(valueName)) return currentValue * -2; //$NON-NLS-1$
	  else return 0;
	}
	if (!"Kampf".equals(groupName)) return 0; //$NON-NLS-1$
    if ("AT".equals(valueName)) return currentValue * -2; //$NON-NLS-1$
    if ("PA".equals(valueName)) return currentValue * -2; //$NON-NLS-1$
    if ("FK".equals(valueName)) return currentValue * -2; //$NON-NLS-1$
    if (valueName.startsWith("INI")) return currentValue * -2; //$NON-NLS-1$
    if ("GS".equals(valueName)) return currentValue * -1; //$NON-NLS-1$
    
    
    return 0;
  }
}
