/*
 Copyright (c) 2006-2009 [Joerg Ruedenauer]
 
 This file is part of RPGameValues.

 RPGameValues is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 RPGameValues is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with RPGameValues; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package rpgamevalues.metadata.logic;

import rpgamevalues.metadata.IGameValue;
import rpgamevalues.metadata.ProbeType;

abstract class AbstractCalculatedValue implements IGameValue {

  /* (non-Javadoc)
   * @see rpgamevalues.metadata.IGameValue#getGameValueType()
   */
  @Override
  public GameValueType getGameValueType() {
    return GameValueType.Number;
  }

  /* (non-Javadoc)
   * @see rpgamevalues.metadata.IGameValue#getMax()
   */
  @Override
  public int getMax() {
    return 0;
  }

  /* (non-Javadoc)
   * @see rpgamevalues.metadata.IGameValue#getMin()
   */
  @Override
  public int getMin() {
    return 0;
  }

  /* (non-Javadoc)
   * @see rpgamevalues.metadata.IGameValue#getProbeModificator(int, int, rpgamevalues.metadata.ProbeType)
   */
  @Override
  public int getProbeModificator(int currentValue, int defaultValue,
      ProbeType probeType) {
    return 0;
  }

  /* (non-Javadoc)
   * @see rpgamevalues.metadata.IGameValue#getProbeModificator(int, rpgamevalues.metadata.ProbeType)
   */
  @Override
  public int getProbeModificator(int currentValue, ProbeType probeType) {
    return 0;
  }

  /* (non-Javadoc)
   * @see rpgamevalues.metadata.IGameValue#getStartValue()
   */
  @Override
  public Object getStartValue() {
    return null;
  }

  /* (non-Javadoc)
   * @see rpgamevalues.metadata.IGameValue#getValueModificator(int, int, java.lang.String)
   */
  @Override
  public int getValueModificator(int currentValue, int defaultValue, String groupName,
      String valueName) {
    return 0;
  }

  /* (non-Javadoc)
   * @see rpgamevalues.metadata.IGameValue#getValueModificator(int, java.lang.String)
   */
  @Override
  public int getValueModificator(int currentValue, String groupName, String valueName) {
    return 0;
  }

  /* (non-Javadoc)
   * @see rpgamevalues.metadata.IGameValue#hasDefault()
   */
  @Override
  public boolean hasDefault() {
    return true;
  }

  /* (non-Javadoc)
   * @see rpgamevalues.metadata.IGameValue#hasMax()
   */
  @Override
  public boolean hasMax() {
    return false;
  }

  /* (non-Javadoc)
   * @see rpgamevalues.metadata.IGameValue#hasMin()
   */
  @Override
  public boolean hasMin() {
    return false;
  }

  /* (non-Javadoc)
   * @see rpgamevalues.metadata.IGameValue#isCalculated()
   */
  @Override
  public boolean isCalculated() {
    return true;
  }

}
