package rpgamevalues.metadata.rolemaster;

import rpgamevalues.metadata.AbstractGameValue;
import rpgamevalues.metadata.ProbeType;

public class PowerPoints extends AbstractGameValue {

	@Override
	public String getName() {
		return "Power Points";
	}
	
	public boolean hasMin() { return true; }
	public boolean hasDefault() { return true; }
	
	public int getMin() { return 0; }
	
	public Object getStartValue() {
		return 0;
	}
	
	public int getProbeModificator(int currentValue, int defaultValue, ProbeType probeType) {
		int fourth = defaultValue / 4;
		int half = defaultValue / 2;
		
		switch (probeType) {
		case SPELL:
			if (currentValue < fourth) return 30;
			if (currentValue < half) return 20;
			if (currentValue < defaultValue - fourth) return 10;
			return 0;
	    default:
		    return 0;		
		}
	}

}
